The code to run the cooperative and independent minibatching implementations used in the paper
can be found in the `dgl_coop/examples/pytorch/graphsage/advanced` directory. The script for cooperative minibatching
is `train_dist_coop.py` and the script for independent minibatching is `train_dist_indep.py`.

The core implementation of cooperative minibatching is located in `dgl_coop/python/dgl/contrib/dist_sampling/dist_graph.py`.

The dependent minibatching approach presented in Section 3.2 is
implemented with the PRNG trick explained in Appendix A.5, "Smoothed Dependent Minibatching" subsection, inside the
file `dgl_coop/src/random/continuous_seed.h`. The `continuous_seed` class defined
in this file is used inside the LABOR sampling algorithm to generate its random numbers. `continuous_seed` is initialized
with seeds `z_1` and `z_2` in the constructor and for any vertex `t`, the random number `r_t` is computed with
`continuous_seed::uniform(t)` usable for both the CPU and CUDA GPUs.

To install and run the code, the submodules under `dgl_coop/thirt_party` directory needs to be populated with
the submodules listed in `dgl_coop/.gitmodules`. We didn't have the time to provide our code in an easily installable
and runnable state, we hoped that releasing our code even in this state would increase the credibility of our results
and approach. We will make sure that the camera-ready version will have a more accessible code release.
